/**
 * Bosch OSAL MockUp
 */


#if !defined(MY_BOSCH_OSAL_IF_MOCKUP_INCLUDE)
#define MY_BOSCH_OSAL_IF_MOCKUP_INCLUDE

#ifdef USE_DLT_TRACE
#include "IAmControlReceiverShadow.h"
#include "shared/CAmDltWrapper.h"

#include <stdarg.h>

#include <dlt/dlt.h>
DLT_IMPORT_CONTEXT(ControllerPlugin);



namespace myStringUtil
{
   inline std::string myString_format(const std::string fmt, ...)
   {
      int size = 100;
      std::string str;
      va_list ap;
      while (1) {
         str.resize(size);
         va_start(ap, fmt);
         int n = vsnprintf((char *)str.c_str(), size, fmt.c_str(), ap);
         va_end(ap);
         if (n > -1 && n < size) {
            str.resize(n);
            return str;
         }
         if (n > -1)
            size = n + 1;
         else
            size *= 2;
      }
      return str;
   }
}

#define  ETG_CENUM(x, y) y
#define  ETG_ENUM(x, y) y

//remove complete path
#define FILE (strrchr(__FILE__, '/') ? strrchr(__FILE__, '/') + 1 : __FILE__)

#define ETG_TRACE_ERR_SUBSTITUTE(a) logInfo(&ControllerPlugin,DLT_LOG_INFO, myStringUtil::myString_format a , FILE, __LINE__);
//#define ETG_TRACE_ERR_SUBSTITUTE(a) logInfo(&ControllerPlugin,DLT_LOG_INFO, myStringUtil::myString_format a );
#define ETG_TRACE_ERR(a)    ETG_TRACE_ERR_SUBSTITUTE(a);
#define ETG_TRACE_ERRMEM(a) ETG_TRACE_ERR_SUBSTITUTE(a);
#define ETG_TRACE_FATAL(a)  ETG_TRACE_ERR_SUBSTITUTE(a);

#define ETG_TRACE_INFO_SUBSTITUTE(a) logInfo(&ControllerPlugin,DLT_LOG_INFO, myStringUtil::myString_format a , FILE, __LINE__);
//#define ETG_TRACE_INFO_SUBSTITUTE(a) logInfo(&ControllerPlugin,DLT_LOG_INFO, myStringUtil::myString_format a);
#define ETG_TRACE_USR4(a) ETG_TRACE_INFO_SUBSTITUTE(a)
#define ETG_TRACE_USR3(a) ETG_TRACE_INFO_SUBSTITUTE(a)
#define ETG_TRACE_USR2(a) ETG_TRACE_INFO_SUBSTITUTE(a)
#define ETG_TRACE_USR1(a) ETG_TRACE_INFO_SUBSTITUTE(a)

#else

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "trace_if.h"
// include for trace backend
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
 // include for etg support lib
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"
//Use this define for AudioStack Traces
#define TR_COMP_AUDIOSTACK          (TR_COMP_AUDIOMANAGEMENT + 0xFF)

#endif

#endif
